<?php

const URL = 'https://www.cvplugin.com';

function register_cv_builder_routes() {
	register_rest_route('cv-builder', '/create', [
		'methods' => 'POST',
		'callback' => 'rest_create_resume',
		'permission_callback' => function($request){ return true; },
		'args' => [
			'html' => [
				'validate_callback' => function( $param, $request, $key ) {
					return is_string( $param );
				}
			]
		]
	]);
}

function rest_create_resume($request) {
	$colors = $request->get_param('colors');
	$html = $request->get_param('html');
	$data = $request->get_param('data');
	$css = $request->get_param('css');

	$url = URL . '/wp-json/pdf-builder/v2/create/resume';
	$curl_data = [
		'css' => $css,
		'data' => $data,
		'html' => $html,
		'colors' => $colors
	];
	$curl_response = sendAPIRequest($url, $curl_data);

	$response = new WP_REST_Response($curl_response);
	$response->set_status( 201 );
	return $response;
}