<?php

require_once dirname( __FILE__ ) . '/curl.php';

function generateToken() {
	$url = API_TOKEN_URL;
	$body = [
		'grant_type' => 'password',
		'scope' => 'admin',
		'admin_email' => API_USER_EMAIL,
		'password' => API_USER_PASS,
		'client_id' => API_CLIENT_ID,
		'client_secret' => API_CLIENT_SECRET
	];

	$token_data = post_curl_request($url, $body);
	update_option('gather-registration-token', $token_data);

	return $token_data['access_token'];
}

function getSavedToken() {
	$token_data = get_option('gather-registration-token', false);

	if ( $token_data !== false && is_array($token_data) && array_key_exists('access_token', $token_data)) {
		$url = API_TOKEN_URL . '/v1/users';
		$token = $token_data['access_token'];
		$token_data = get_curl_request($url, $token);
	}

	if (is_array($token_data) && array_key_exists('access_token', $token_data)) {
		return $token_data['access_token'];
	} else {
		return generateToken();
	}
}