<?php

const DEFAULT_FIELD_WIDTH  = 12;

require_once dirname( __FILE__ ) . '/helpers.php';
require_once dirname( __FILE__ ) . '/API/index.php';

function form_response() {
	if (isset($_POST['firstname']) &&
		isset($_POST['lastname']) &&
		isset($_POST['email']) &&
		isset($_POST['country']) &&
		isset($_POST['over16']) && $_POST['over16'] === 'checked' &&
		isset($_POST['consent']) && $_POST['consent'] === 'checked' &&
		isset($_POST['distributionAgreement']) && $_POST['distributionAgreement'] === 'checked' &&
		isset($_POST['gatherConsent']) && $_POST['gatherConsent'] === 'checked') {
		$firstname = input_cleaner($_POST['firstname']);
		$lastname = input_cleaner($_POST['lastname']);
		$email = input_cleaner($_POST['email']);
		$country = input_cleaner($_POST['country']);
		
		$data = apply_filters('gather-register', $firstname, $lastname, $email, $country);
		if ($data['status'] === 'success') {
			return '<span style="font-size: 24px;font-weight: 700;color: green;">'. $data['msg'] . '</span>';
		} else {
			return '<span style="font-size: 24px;font-weight: 700;color: red;">'. $data['msg'] . '</span>';
		}
	}
	return null;
}

function js_submit_function() {
	return <<<ENDHTML
	<script>
		function submitForm(elt, evt) {
			// Disable elements that we don't want to validate.
			const hidden_elts = document.querySelectorAll("input:not(.gather-form input), textarea:not(.gather-form textarea), select:not(.gather-form select)");
			console.log(hidden_elts);
			for (let i = 0; i < hidden_elts.length; i++) {
				hidden_elts[i].disabled = true;
				console.log(hidden_elts[i]);
			}

			// If HTML5 Validation is available let it run. Otherwise prevent default.
			if (typeof this.checkValidity === 'function' && this.checkValidity()) {
				for (let i = 0; i < hidden_elts.length; i++)
					hidden_elts[i].disabled = false;
				return true;
			}
			/*evt.preventDefault();

			// Re-enable things that we previously disabled.
			for (let i = 0; i < hidden_elts.length; i++)
				hidden_elts[i].disabled = false;*/
		}
	</script>
	ENDHTML;
}

function gather_registration_form() {
	global $wp;
	$current_url = home_url( add_query_arg( array(), $wp->request ) );

	$form = get_option('gather-registration-form', []);
	$msg = form_response();

	$html = "<form class=\"gather-form\" method=\"POST\" action=\"${current_url}\" onclick=\"submitForm(this, event);\">";
	if ($msg !== null)
		$html .= "<p>${msg}</p>";

	$html .= "<div class=\"form-row\">";
	foreach ($form as $key => $field) {
		$html .= form_field($field);
	}

	$html .= js_submit_function();
	$html .= "<div class=\"col-12\"><button class=\"btn btn-primary\" type=\"submit\">Register</button></div>";
	$html .= "</div>";
	return $html;
}

function form_field($field) {
	if (property_exists($field, "width")) {
		$width = $field->width;
	} else {
		$width = DEFAULT_FIELD_WIDTH;
	}
	$html = "<div class=\"col-${width}\">";
	$html .= "<div class=\"form-group\">";
	switch ($field->type) {
		case 'input':
			$html .= input_field($field->name, $field->label);
			break;
		case 'select':
			$html .= select_field($field->name, $field->label);
			break;
		case 'checkbox':
			$html .= checkbox_field($field->name, $field->label);
			break;
		default:
			break;
	}
	$html .= "</div></div>";
	return $html;
}

function input_field($name, $label) {
	$id = uniqid($name . '_');
	$html = "<label for=\"${id}\">";
	$html .= $label;
	$html .= "</label>";
	$html .= "<input type=\"text\" name=\"${name}\" value=\"\" class=\"form-control\" id=\"${id}\" required>";
	return $html;
}

function select_field($name, $label) {
	$options = get_option('gather-registration-countries', []);

	$id = uniqid($name . '_');
	$html = "<label for=\"${id}\">";
	$html .= $label;
	$html .= "</label>";
	$html .= "<select name=\"${name}\" class=\"form-control\" id=\"${id}\" required>";
	$html .= "<option selected=\"selected\" value=\"\">Please Select</option>";
	foreach ($options as $key => $option) {
		$html .= "<option value=\"{$option->value}\">{$option->label}</option>";
	}
	$html .= "</select>";
	return $html;
}

function checkbox_field($name, $label) {
	$id = uniqid($name . '_');
	$html = "<div class=\"custom-control custom-checkbox mr-sm-2\">";
	$html .= "<input type=\"checkbox\" name=\"${name}\" value=\"checked\" class=\"custom-control-input\" id=\"${id}\" required>";
	$html .= "<label class=\"custom-control-label\" for=\"${id}\">";
	$html .= $label;
	$html .= "</label></div>";
	return $html;
}