<?php

function create_post_type() {
	register_post_type( 'document',
		[
			'labels' => [
				'name' => __( 'Documents' ),
				'singular_name' => __( 'Document' )
			],
			'public' => true,
			'has_archive' => true,
			'show_in_rest' => true,
			'rewrite' => ['slug' => 'documents']
		]
	);
}

function create_document_post($http_host, $title, $data, $html) {
	$new_post = array(
		'post_author' => 0,
		'post_title' => $title,
		'post_content' => $html,
		'post_type' => 'document',
		'post_status' => 'publish',
		'post_category' => array(0),
		'post_date' => date('Y-m-d H:i:s'),
		'meta_input' => ['host' => $http_host, 'data' => $data ]
	);
	$post_id = wp_insert_post($new_post);
	return $post_id;
}