<?php
$width = 595;
$height = 842;
$intro = 20;
$padding_top = 50;
$padding_top_img = 10;
$font_size = 12;
$padding_unit = 10;

function count_line_description($description) {
	$count = 1;
	$n = 0;
	$arr = explode(' ', $description);
	foreach ($arr as $word) {
		$l = strlen($word);
		if ( $l + $n + 1 > 99) {
			$count += 1;
			$n = $l;
		} else {
			$n += $l + 1;
		}
	}
	return $count;
}

function count_lines_work($work) {
	$count = 0;
	$things = ['thing1', 'thing2', 'thing3'];
	foreach ($work as $obj) {
		$n = strlen($obj['position']);
		if ( $n > 62 ) {
			$count += 2;
		} else {
			$count += 1;
		}
		$n = strlen($obj['organisation'] . ' | ' . $obj['date']['start'] .' - '.$obj['date']['end']);
		if ( $n > 73 ) {
			$count += 2;
		} else {
			$count += 1;
		}
		foreach ($things as $thing) {
			$n = strlen($obj[$thing]);
			if ( $n > 77 ) {
				$count += 2;
			} else {
				$count += 1;
			}
		}
	}
	return $count;
}

function count_lines_education($education) {
	$count = 0;
	$things = ['thing1', 'thing2', 'thing3'];
	foreach ($education as $obj) {
		$n = strlen($obj['organisation']);
		if ( $n > 62 ) {
			$count += 2;
		} else {
			$count += 1;
		}
		$n = strlen($obj['formation'] . ' | ' . $obj['date']['start'] .' - '.$obj['date']['end']);
		if ( $n > 73 ) {
			$count += 2;
		} else {
			$count += 1;
		}
		foreach ($things as $thing) {
			$n = strlen($obj[$thing]);
			if ( $n > 77 ) {
				$count += 2;
			} else {
				$count += 1;
			}
		}
	}
	return $count;
}

function count_hobbies($hobbies) {
	return count($hobbies);
}

if ( (count($this->education) + count($this->work)) >= 4) {
	$desc = count_line_description($this->description);
	$work = count_lines_work($this->work);
	$edu = count_lines_education($this->education);
	$hob = count_hobbies($this->hobby);
	$n = $desc + $work + $edu + $hob;
	if ( $n > 38 ) {
		if ( (count($this->education) + count($this->work)) >= 4) {
			$intro = 6;
			$padding_top = 5;
			$padding_top_img = 5;
		}
		if ( (count($this->education) + count($this->work)) == 6) {
			$font_size = 10.9;
		} else if ( (count($this->education) + count($this->work)) == 5) {
			$font_size = 11.25;
		}
	}
}
?>
<style type="text/css">
	* {
		margin: 0;
		padding: 0;
		font-size: <?php echo $font_size;?>pt;
		font-weight: normal;
	}

	table {
		width: 100%;
		border-spacing : 0;
		border-collapse : collapse;
	}

	td, th {
		vertical-align: middle;
	}

	.page {
		height: 842pt;
		width: 595pt;
		overflow: hidden;
	}

	.intro {
		height: <?php echo $intro; ?>%;
	}

	.content {
		height: <?php echo (100 - $intro); ?>%;
	}

	.left {
		width: 36%;
		color: white;
		background-color: <?php echo $this->color;?>;
	}

	.left .content {
		padding-left: 6%;
		padding-right: 6%;
		text-align: center;
	}

	.right .content {
		padding-left: 6%;
		padding-right: 6%;
	}

	.right {
		width: 64%;
	}

	.name {
		padding-top: <?php echo $padding_top;?>pt;
		padding-left: 6%;
		letter-spacing: 2px;
		font-weight: 600;
		font-size: <?php echo (2.5 * $font_size);?>pt;
		color: <?php echo $this->color;?>;
	}

	.title {
		letter-spacing: 4px;
		font-weight: 400;
		font-size: <?php echo (2 * $font_size);?>pt;
		color: <?php echo $this->secondary_color;?>;
	}

	.rating-section {
		padding-top: 2.5pt;
		margin-left: auto;
		margin-right: auto;
		width: 55pt;
	}

	.level-circle {
		margin-left: 1pt;
		margin-right: 1pt;
		display: inline-block;
		width: 5pt;
		height: 5pt;
		border: 1px solid white;
		border-radius: 5%;
	}

	.level-circle.full {
		background-color: white;
	}

	.section-title {
		font-family: "Helvetica";
		font-size: <?php echo (1.16 * $font_size);?>pt;
		letter-spacing: 4px;
		font-weight: 500;
		color: <?php echo $this->secondary_color;?>;
	}

	.left .section-title {
		font-weight: 600;
		color: white;
	}

	.element {
		font-family: "Arial";
		color:  #444440;
	}

	.element-title {
		font-weight: 500;
		font-size:  <?php echo $font_size;?>pt;
	}

	.element-info {
		font-weight: normal;
		font-size:  <?php echo (0.9 * $font_size);?>pt;
	}

	.element-paragraph {
		font-size: <?php echo (0.8 * $font_size);?>pt;
	}

	.section {
		padding-top: 10pt;
	}

	.left .content .section {
		padding-top: 30pt;
	}

	.element {
		padding-bottom: 10pt;
	}

	.section .element ul.list {
		padding-left: 30pt;
	}

	.intro .img {
		padding-top: <?php echo $padding_top_img;?>pt;
		width: 63.8%;
		margin-left: auto;
		margin-right: auto;
		text-align: center;
	}

	.intro .img img {
		border-radius: 50%;
		height: 63.8%;
	}

	.img-link {
		position: fixed;
		width: 50pt;
		bottom: 40pt;
		right: 5pt;
	}

	img.logo {
		width: 50pt;
	}
</style>
<table class="page">
	<tbody>
		<tr>
			<td class="left">
				<div class="intro">
					<div class="img">
						<img src="<?php echo ($this->picture != null)? $this->picture: ''; ?>">
					</div>
				</div>
			</td>
			<td class="right">
				<div class="intro">
					<p class="name"><?php echo $this->firstname . ' ' . $this->lastname; ?></p>
					<!--<p class="title">IT Project Manager</p>-->
				</div>
			</td>
		</tr>
		<tr>
			<td class="left">
				<div class="content">
					<div class="section">
						<p class="section-title">CONTACT ME AT</p>
						<div class="list">
							<p class="list-elt"><?php echo $this->email; ?></p>
							<p class="list-elt"><?php echo $this->nationality; ?></p>
							<p class="list-elt"><?php echo $this->phone; ?></p>
						</div>
					</div>

					<div class="section">
						<p class="section-title">LANGUAGES</p>
						<div class="list">
							<?php for ( $i = 0; $i < count($this->languages); $i++ ) { ?>
							<p class="list-elt"><?php echo $this->languages[$i]['language'].' '.$this->languages[$i]['level']; ?></p>
							<?php } ?>
						</div>
					</div>

					<div class="section">
						<p class="section-title">SOFTSKILLS</p>
						<div class="list">
							<?php for ( $i = 0; $i < count($this->softskills); $i++ ) { ?>
							<p class="list-elt"><?php echo $this->softskills[$i]['softskill']; ?></p>
							<div class="rating-section">
								<?php for ($j=0;$j<5;$j++) {
									if ($j < $this->softskills[$i]['level']) { 
										echo '<div class="level-circle full"></div>';
									} else {
										echo '<div class="level-circle"></div>';
									}
								} ?>
							</div>
							<?php } ?>
						</div>
					</div>

					<div class="section">
						<p class="section-title">IT SKILLS</p>
						<div class="list">
							<?php for ( $i = 0; $i < count($this->softwareskills); $i++ ) { ?>
							<p class="list-elt"><?php echo $this->softwareskills[$i]['softwareskill']; ?></p>
							<div class="rating-section">
								<?php for ($j=0;$j<5;$j++) {
									if ($j < $this->softwareskills[$i]['level']) { 
										echo '<div class="level-circle full"></div>';
									} else {
										echo '<div class="level-circle"></div>';
									}
								} ?>
							</div>
							<?php } ?>
						</div>
					</div>
				</div>
			</td>
			<td class="right">
				<div class="content">
					<div class="section">
						<p class="section-title">PERSONAL PROFILE</p>
						<div class="element">
							<p class="element-paragraph"><?php echo $this->description; ?></p>
						</div>
					</div>

					<div class="section">
						<p class="section-title">WORK EXPERIENCE</p>
						<?php for ($i = 0; $i < count($this->work); $i++) { ?>
							<div class="element">
								<p class="element-title"><?php echo $this->work[$i]['position']; ?></p>
								<p class="element-info"><?php echo $this->work[$i]['organisation']; ?>  | <?php echo $this->work[$i]['date']['start'] . ' - ' . $this->work[$i]['date']['end']; ?></p>
								<ul class="list">
									<li class="element-paragraph"><?php echo $this->work[$i]['thing1']; ?></li>
									<li class="element-paragraph"><?php echo $this->work[$i]['thing2']; ?></li>
									<li class="element-paragraph"><?php echo $this->work[$i]['thing3']; ?></li>
								</ul>
							</div>
						<?php } ?>
					</div>

					<div class="section">
						<p class="section-title">EDUCATIONAL HISTORY</p>
						<?php for ($i = 0; $i < count($this->education); $i++) { ?>
							<div class="element">
								<p class="element-title"><?php echo $this->education[$i]['organisation']; ?></p>
								<p class="element-info"><?php echo $this->education[$i]['formation']; ?> | <?php echo $this->education[$i]['date']['start'] . ' - ' . $this->education[$i]['date']['end']; ?></p>
								<ul class="list">
									<li class="element-paragraph"><?php echo $this->education[$i]['thing1']; ?></li>
									<li class="element-paragraph"><?php echo $this->education[$i]['thing2']; ?></li>
									<li class="element-paragraph"><?php echo $this->education[$i]['thing3']; ?></li>
								</ul>
							</div>
						<?php } ?>
					</div>

					<div class="section">
						<p class="section-title">HOBBIES</p>
						<div class="element">
							<?php for ( $i = 0; $i < count($this->hobby); $i++ )  { ?>
							<p class="element-paragraph"><?php echo $this->hobby[$i]['hobby']; ?></p>
							<?php } ?>
						</div>
					</div>
				</div>

				<a href="https://www.cvplugin.com/" target="_blank" class="img-link">
					<img src="<?php echo convert_image_to_base64(dirname(__FILE__) . '/images/logo.png'); ?>" class="logo">
				</a>
			</td>
		</tr>
	</tbody>
</table>