<?php

class Resume {
	private $width;
	private $height;
	private $margin;

	private $firstname = '';
	private $lastname = '';
	private $email = '';
	private $phone = null;
	private $title = '';
	private $description = '';
	private $nationality = null;
	private $languages = null;
	private $hardskills = null;
	private $softskills = null;
	private $softwareskills = null;
	private $work = null;
	private $education = null;
	private $hobby = null;
	private $color = '';
	private $picture = null;
	private $secondary_color = '';
	private $resume_template = null;

	private $path = null;
	private $json_path = null;

	private $html = null;

	function __construct($args) {

		$this->path = plugin_dir_path( __FILE__ );
		$this->json_path = $this->path . "json/";

		$this->firstname = $args['firstname'];
		$this->lastname = $args['lastname'];
		$this->email = $args['email'];
		$this->phone = $args['phone'];
		$this->description = $args['description'];
		$this->set_nationality($args['nationality']);
		$this->set_languages($args['languages']);

		$this->set_softskills($args['softskills'], get_json_data($this->json_path.'softskills.json'));
		$this->set_softwareskills($args['softwareskills'], get_json_data($this->json_path.'softwareskills.json'));
		//$this->set_hardskills($args['hardskills'], get_json_data('hardskills'));
		
		$this->set_work($args['work']);
		$this->set_education($args['education']);
		$this->hobby = $args['hobby'];
		$this->set_color($args['color']);
		$this->set_resume_template($args['resume_template']);
		$this->set_picture($args['pic']);
	}

	private function set_picture($picture) {
		if ($args['pic'] !== false) {
			$this->picture = $picture;
		}
	}

	private function set_resume_template($template) {
		$file = plugin_dir_path( __FILE__ ) . $template;
		if ( file_exists($file) ) {
			$this->resume_template = $file;
		} else {
			$this->resume_template = plugin_dir_path( __FILE__ ) . '1.php';
		}
	}

	private function set_color($color_string) {
		switch($color_string) {
			case 'yellow':
				$this->color = '#DCD800';
				$this->secondary_color = '#F3F176';
				break;
			case 'blue':
				$this->color = '#335384';
				$this->secondary_color = '#5ba7d1';
				break;
			case 'pink':
				$this->color = '#E800FF';
				$this->secondary_color = '#F7A5FF';
				break;
			case 'purple':
				$this->color = '#4A235A';
				$this->secondary_color = '#A569BD';
				break;
			case 'green':
				$this->color = '#186A3B';
				$this->secondary_color = '#58D68D';
				break;
			case 'orange':
			default:
				$this->color = '#FF6400';
				$this->secondary_color = '#FFB381';
				break;
		}
	}

	private function sort_array($arr, $column, $desc = false) {
		$order = SORT_ASC;
		if ( $desc )
			$order = SORT_DESC;
		$tmp = array_column($arr, $column);
		array_multisort($tmp, $order, $arr);
		return $arr;
	}

	private function sort_array_by_date($arr, $desc = false) {
		$order = SORT_ASC;
		if ( $desc )
			$order = SORT_DESC;
		$tmp = array_column($arr, 'date');
		for ($i = 0; $i < count($tmp); $i++) {
			$explode = explode('/', $tmp[$i]['end']);
			$day = $explode[1];
			$month = $explode[0];
			$year = $explode[2];
			$tmp[$i]['end'] = $year .'/'. $month;
		}
		array_multisort($tmp, $order, $arr);
		return $arr;
	}

	private function set_languages($languages) {
		$languages_list = get_json_data($this->json_path.'languages.json');
		for ($i = 0; $i < count($languages); $i++) {
			$lang_code = $languages[$i]['language'];
			$language = $languages_list[$lang_code]['name'];
			$languages[$i]['language'] = $language;
		}
		$this->languages = $this->sort_array($languages, 'level', true);
	}

	private function set_nationality($nationality) {
		$nationalities_list = get_json_data($this->json_path.'nationalities.json');
		$this->nationality = $nationalities_list[$nationality]['name'];
	}

	private function set_softskills($skills, $skills_list) {
		for ($i = 0; $i < count($skills); $i++) {
			$skill_code = $skills[$i]['softskill'];
			$skill = $skills_list[$skill_code]['name'];
			$skills[$i]['softskill'] = $skill;
		}
		$this->softskills = $this->sort_array($skills, 'level', true);
	}

	private function set_softwareskills($skills, $skills_list) {
		for ($i = 0; $i < count($skills); $i++) {
			$skill_code = $skills[$i]['softwareskill'];
			$skill = $skills_list[$skill_code]['name'];
			$skills[$i]['softwareskill'] = $skill;
		}
		$this->softwareskills = $this->sort_array($skills, 'level', true);
	}

	private function set_hardskills($skills, $skills_list) {
		if ( $skills == null ) {
			$this->hardskills = [];
			return;
		}

		for ($i = 0; $i < count($skills); $i++) {
			$skill_code = $skills[$i]['hardskill'];
			$skill = $skills_list[$skill_code]['name'];
			$skills[$i]['hardskill'] = $skill;
		}
		$this->hardskills = $this->sort_array($skills, 'level', true);
	}

	private function set_work($work) {
		$this->work = $this->sort_array_by_date($work, true);
	}

	private function set_education($education) {
		$this->education = $this->sort_array_by_date($education, true);
	}

	public function get_width() {
		return $this->width;
	}

	public function get_height() {
		return $this->height;
	}

	public function get_margin() {
		return $this->margin;
	}

	private function getRenderedHTML($path)
	{
		ob_start();
		include($path);
		$content = ob_get_contents(); 
		ob_end_clean();

		return $content;
	}

	private function create_html() {
		$html = '';
		//$file = plugin_dir_path( __FILE__ ) . 'templates/template_1.php';
		$file = $this->resume_template;

		$html = $this->getRenderedHTML($file);

		$this->html = $html;
	}

	public function get_html() {
		if ( $this->html == null )
			$this->create_html();
		return $this->html;
	}
}


function create_resume_html($request) {
	$args = array();
	$args['firstname'] = $request->get_param('firstname');
	$args['lastname'] = $request->get_param('lastname');
	$args['email'] = $request->get_param('email');
	$args['phone'] = $request->get_param('phone');
	$args['description'] = $request->get_param('description');
	$args['languages'] = $request->get_param('languages');
	$args['nationality'] = $request->get_param('nationality');
	$args['work'] = $request->get_param('work');
	$args['education'] = $request->get_param('education');
	$args['hobby'] = $request->get_param('hobby');
	$args['softskills'] = $request->get_param('softskills');
	//$args['hardskills'] = $request->get_param('hardskills');
	$args['softwareskills'] = $request->get_param('softwareskills');
	$args['color'] = $request->get_param('color');
	$args['resume_template'] = $request->get_param('resume_template');
	$args['title'] = "Digital Marketer";

	$args['pic'] = false;
	$files = $request->get_file_params();
	if (!empty( $files ) && !empty( $files['pic']) && is_uploaded_file( $files['pic']['tmp_name'] )) {
		$check = getimagesize($files['pic']['tmp_name']);
		if($check !== false)
			$args['pic'] = convert_image_to_base64($files['pic']['tmp_name']);
	}
	
	//$html = create_html_from_data($args);
	$resume = new Resume($args);
	$html = $resume->get_html();

	return $html;
}